<?php

namespace App\Http\Controllers;

use App\Models\Formulario;
use App\Models\Cargo;

use Illuminate\Http\Request;

use Inertia\Inertia;
use Illuminate\Support\Facades\Storage;



class FormularioController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        
        return Inertia::render('Welcome', [
            'cargos' => Cargo::all()
        ]);
    }


     public function success()
    {
        
        return Inertia::render('Success', [
            
        ]);
    }



    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {

        
         $request->validate([
            'nombre' => 'required|max:150',
            'apellido' => 'required|max:150',
            'rut' => 'required|max:100',
            'telefono' => 'required|max:100',
            'mail' => 'required|max:100',
            'cargos' => 'required|array',
            'fec_nacimiento' => 'required|date',
            'fec_disponibilidad' => 'required|date',
            'experiencia' => 'required|max:255',
            'adjunto' => 'required|file|mimes:png,jpg,gif,pdf,docx,doc',
        ]);
        
        $formulario = Formulario::create($request->all());
        
        if($request->hasFile('adjunto')){
            $adjunto= $formulario->id.'.'.$request->file('adjunto')->getClientOriginalExtension();   
            $request->file('adjunto')->storeAs('public/data', $adjunto);
        
        }

        
        $formulario->cargos()->sync($request->cargos);

        return redirect('success')->with('success','Formulario creado');

    }

    /**
     * Display the specified resource.
     */
    public function show(Formulario $formulario)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(Formulario $formulario)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, Formulario $formulario)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Formulario $formulario)
    {
        //
    }
}
