<?php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\Formulario>
 */
class FormularioFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        return [
            'nombre'  => $this->faker->firstName(),
            'apellido' => $this->faker->lastName(),
            'rut'=> $this->faker->randomNumber(8,true),
            'mail'=> $this->faker->email(),
            'telefono'=> $this->faker->randomNumber(8,true),
            
            'fec_nacimiento'=> $this->faker->date(),
            'fec_disponibilidad'=> $this->faker->date(),
            'experiencia'=> $this->faker->text(200)
           

        ];
    }
}
